/* - AdvServoDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JSlider;

public class AdvServoDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numServosTxt;
    private JComboBox servoCmb;
    private JTextField actVelTxt;
    private JTextField actPosTxt;
    private JTextField currentTxt;
    private JSlider posScrl;
    private JTextField targetPosTxt;
    private JSlider velScrl;
    private JTextField targetVelTxt;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JCheckBox engagedChk;
    private JCheckBox rampingChk;
    
    /** Creates a new instance of AdvServoDetachListener */
    public AdvServoDetachListener(JFrame appFrame, JTextField attachedTxt,
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
            JTextField numServosTxt, JComboBox servoCmb, JTextField actVelTxt,
            JTextField actPosTxt, JTextField currentTxt, JSlider posScrl,
            JTextField targetPosTxt, JSlider velScrl, JTextField targetVelTxt,
            JSlider accelScrl, JTextField accelTxt, JCheckBox engagedChk,
            JCheckBox rampingChk)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numServosTxt = numServosTxt;
        this.servoCmb = servoCmb;
        this.actVelTxt = actVelTxt;
        this.actPosTxt = actPosTxt;
        this.currentTxt = currentTxt;
        this.posScrl = posScrl;
        this.targetPosTxt = targetPosTxt;
        this.velScrl = velScrl;
        this.targetVelTxt = targetVelTxt;
        this.accelScrl = accelScrl;
        this.accelTxt = accelTxt;
        this.engagedChk = engagedChk;
        this.rampingChk = rampingChk;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            AdvancedServoPhidget detached = (AdvancedServoPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numServosTxt.setText("");
            actPosTxt.setText("");
            actVelTxt.setText("");
            currentTxt.setText("");
            
            engagedChk.setSelected(false);
            engagedChk.setEnabled(false);
            rampingChk.setSelected(false);
            rampingChk.setEnabled(false);
            
            posScrl.setEnabled(false);
            posScrl.setValueIsAdjusting(true);
            posScrl.setValue(0);
            targetPosTxt.setText(Integer.toString(posScrl.getValue()));
            posScrl.setValueIsAdjusting(false);
            velScrl.setEnabled(false);
            velScrl.setValueIsAdjusting(true);
            velScrl.setValue(0);
            targetVelTxt.setText(Integer.toString(velScrl.getValue()));
            velScrl.setValueIsAdjusting(false);
            accelScrl.setEnabled(false);
            accelScrl.setValueIsAdjusting(true);
            accelScrl.setValue(0);
            accelTxt.setText(Integer.toString(accelScrl.getValue()));
            accelScrl.setValueIsAdjusting(false);
            
            servoCmb.setEnabled(false);
            servoCmb.removeAllItems();
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
